﻿package 
{

	import flash.display.MovieClip;
	import flash.text.TextFormat;
	import fl.transitions.Tween;
	import fl.transitions.TweenEvent;
	import fl.transitions.easing.*;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import com.greensock.TweenLite;
	import com.greensock.easing.*;

	public class MainDocument extends MovieClip
	{

		var animationSeconds:Number = 1;
		var delaySeconds:Number = .1;

		var currentCount:Number = 0;

		var letters:Array;
		var timer:Timer;

		public function MainDocument()
		{
			Setup();
		}

		public function Setup()
		{
			letters = new Array();

			for (var i:int = 0; i < textClip.numChildren; i++)
			{
				letters.push(textClip.getChildAt(i));
			}

			ShuffleArray(letters);
			StartAnimation();
		}

		public function StartAnimation()
		{
			timer = new Timer(delaySeconds*1000);
			timer.addEventListener(TimerEvent.TIMER, TimerTick);
			timer.start();

			AnimateLetters(currentCount, currentCount + 1);
		}

		public function TimerTick(e:TimerEvent)
		{
			if (currentCount < letters.length)
			{
				AnimateLetters(currentCount, currentCount + 1);
				currentCount++;
			}
			else
			{
				timer.stop();
				timer.removeEventListener(TimerEvent.TIMER, TimerTick);
			}
		}

		public function ShuffleArray(input:Array)
		{
			for (var i:int = input.length-1; i >=0; i--)
			{
				var randomIndex:int = Math.floor(Math.random() * (i + 1));
				var itemAtIndex:Object = input[randomIndex];

				input[randomIndex] = input[i];
				input[i] = itemAtIndex;
			}
		}

		public function AnimateLetters(startIndex:Number, endIndex:Number)
		{
			for (var i:int = startIndex; i < endIndex; i++)
			{
				TweenLite.to(letters[i], animationSeconds, {alpha:0, ease:Cubic.easeIn});
			}
		}
	}

}