﻿/********************************************************/
/*  Copyright © YoAmbulante (alex.nino@yoambulante.com) */
/*                                                      */
/*  You may modify or sell this code, you can do        */
/*  whatever you want with it, I don't mind. Just don't */
/*  forget to contribute with a beer thru the website.  */
/*                                                      */
/*  Visit http://www.yoambulante.com to clarify any     */
/*  doubt with this code. Note that donators have       */
/*  priority on information enquiries.                  */
/*                                                      */
/********************************************************/
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;	
	import flash.events.Event;	
	import flash.events.KeyboardEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.text.TextField;
	
	/**
	 * ...
	 * @author Alex Nino
	 */
	public class Main extends Sprite {
		private var objs:Vector.<Circle>;		
		private var lastindex:uint;
		private var canvas:Bitmap;
		public function Main():void {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			objs = new Vector.<Circle>(9, true);
			lastindex = objs.length - 1;			
			this.mouseChildren = false;
			this.mouseEnabled = false;
			canvas = new Bitmap(new BitmapData(450, 500, true, 0), "auto", true);
			addChild(canvas);
			//create objects and assign weight for them
			objs[0] = new Circle(-1);
			objs[0].px = 0;						
			
			objs[1] = new Circle(9);
			objs[1].px = 100;						
			
			objs[2] = new Circle(2);			
			objs[2].px = 290;						
			
			objs[3] = new Circle(3);			
			objs[3].px = 350;						
			
			objs[4] = new Circle(6);			
			objs[4].px = 430;						
			
			objs[5] = new Circle(-.5);
			objs[5].px = 710;
			
			objs[6] = new Circle(-1.5);
			objs[6].px = 800;
			
			objs[7] = new Circle(2.75);
			objs[7].px = 860;
			
			objs[8] = new Circle(-5);			
			objs[8].px = 1000;						
			
			addEventListener(Event.ENTER_FRAME, onFrame);
			//who am I?
			var textfield:TextField = new TextField();			
			textfield.text = "YoAmbulante.com, Alex Nino - April 11th, 2010 - Elastic Collision Test Loop.";
			textfield.textColor = 0xCCEECC;
			textfield.width = textfield.textWidth + 5;
			textfield.selectable = false;
			addChild(textfield);
			
			stage.addEventListener(KeyboardEvent.KEY_UP, onKey);
		}						
		
		private function onKey(e:KeyboardEvent):void {
			if (e.keyCode == 32) {
				onFrame(null);
			} else if (e.keyCode == 81) {
				removeEventListener(Event.ENTER_FRAME, onFrame);
			}
		}		
		private function onFrame(e:Event):void {						
			var m1:Circle;
			var m2:Circle;
			var collision:Boolean = false;
			var i:int;
			for (i = 0; i <= lastindex; i++) { //check if any collision happens
				m1 = objs[i];
				m2 = i == lastindex ? objs[0] : objs[i + 1];					
				if (Circle.getDistance(Circle.getPerimeterVal(m1.px + m1.vel),Circle.getPerimeterVal(m2.px + m2.vel)) - (m1.width + m2.width) * .5 <= 0) {										
					//coliision happened, stick each other
					var len:Number = Math.abs(m1.vel)+Math.abs(m2.vel);
					var dist:Number = Circle.getDistance(m1.px,m2.px) - (m1.width + m2.width) * .5;
					var temp:Number = m1.px + m1.vel / len * dist;
					m1.px = temp;					
					m2.px = temp + m1.width * .5 + m2.width * .5;					
					//collision response alter vels.					
					var temp1:Number = m1.vel;
					var temp2:Number = m2.vel;
					var totalMass:Number = (m1.mass + m2.mass);					
					m1.vel = (temp1 * (m1.mass - m2.mass) + (2 * m2.mass * temp2)) / totalMass;
					m2.vel = (temp2 * (m2.mass - m1.mass) + (2 * m1.mass * temp1)) / totalMass;						
					collision = true;
					onFrame(null);
					break;
				}
			}			
			if (!collision) { //then move objects to next position depending on their speed.				
				var prev_c:BitmapData = canvas.bitmapData.clone();
				canvas.bitmapData.fillRect(canvas.bitmapData.rect, 0); //clear canvas
				var c:ColorTransform = new ColorTransform(1, .98, 1, .7, 0, -30, 30, 0);
				canvas.bitmapData.draw(prev_c, null, c);
				prev_c.dispose();
				for (i = 0; i <= lastindex; i++) {
					m1 = objs[i];
					m1.px += m1.vel;
					var m:Matrix = new Matrix();
					m.translate(m1.x, m1.y);
					canvas.bitmapData.draw(m1,m);
				}				
			}
		}
		
	}
	
}
import flash.display.Sprite;
import flash.text.TextField;
class Circle extends Sprite {
	public var mass:Number; //in kilograms or whatever you wanna call it.
	public var vel:Number; //speed => pixels per frame
	private var _x:Number;	
	private static const RADIUS:Number = 200;	
	private static const PERIMETER:Number = Math.PI * 2 * RADIUS;
	private static const RAD_IN_DEG:Number = Math.PI / 180;		
	function Circle(speed:Number) {
		super();		
		//this.cacheAsBitmap = true;
		this.mass = 10;		
		this.vel = speed;
		this.graphics.beginFill(0x00CC00, 1);				
		this.graphics.drawCircle(0, 0, 5);		
	}
	public function set px(val:Number):void {		
		_x = getPerimeterVal(val);
		var rad:Number = (_x / PERIMETER) * 360 * RAD_IN_DEG;		
		this.x = 225 + Math.sin(rad) * RADIUS;
		this.y = 250 + Math.cos(rad) * RADIUS;	
		vel += (Math.sin(rad) * -1) * .08; //apply some gravity		
	}	
	public static function getPerimeterVal(val:Number):Number{
		if (val >= PERIMETER) {
			val = val - PERIMETER;
		} else if (val < 0) {
			val = PERIMETER + val;
		}
		return val;
	}
	public static function getDistance(a:Number, b:Number):Number {		
		return Math.min(Math.abs(a-b),Math.min((PERIMETER+a)-b,(PERIMETER+b)-a));
	}
	public function get px():Number {		
		return _x;
	}
}